/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCComponent;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCItemSelectable;
import jclass.bwt.JCListInterface;
import jclass.bwt.JCScrollableInterface;
import jclass.bwt.JCScrolledWindow;
import jclass.bwt.ListConverter;
import jclass.bwt.ListSelection;
import jclass.util.JCVector;

public class JCListComponent
extends JCComponent
implements JCListInterface,
JCScrollableInterface,
JCItemSelectable {
    JCVector items = new JCVector();
    int visible_rows;
    boolean[] selected = new boolean[0];
    boolean[] last_selected = new boolean[0];
    Color selected_bg;
    Color selected_fg;
    boolean multiple_select = false;
    int spacing;
    boolean batched = false;
    boolean needs_recalc = false;
    boolean needs_repaint = false;
    int pref_height_internal;
    int pref_width_internal;
    int row_height_ext = -997;
    int row_height;
    int[] row_heights;
    int[] row_pos;
    int horiz_origin;
    int vert_origin = -999;
    int top_row;
    int bottom_row = -999;
    int last_visible;
    int last_row = -999;
    boolean auto_select = false;
    Object[] userdata_list;
    Rectangle draw_rect = new Rectangle();
    Insets vis = new Insets(0, 0, 0, 0);
    boolean did_selection = false;
    int last_selected_item;
    int start_item;
    int old_start_item;
    int end_item;
    int old_end_item;
    boolean appending = false;
    int focus_row = -1;
    boolean kbd_select = false;
    int selection_type;
    protected JCVector actionListeners = new JCVector(0);
    protected JCVector itemListeners = new JCVector(0);
    private static final String base = "list";
    private static int nameCounter;
    static final int DEFAULT_VISIBLE_ROWS = 4;
    protected JCScrolledWindow scrolled_window;
    Image buffer_image;
    Graphics buffer_image_gc;
    Rectangle clip_rect = new Rectangle();

    public JCListComponent() {
        this(null, null, null);
    }

    public JCListComponent(JCVector jCVector) {
        this(jCVector, null, null);
    }

    public JCListComponent(JCVector jCVector, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.insets = new Insets(5, 5, 5, 5);
        if (this.getClass().getName().equals("jclass.bwt.JCListComponent")) {
            this.getParameters(applet);
        }
        if (jCVector != null) {
            this.setItems(jCVector);
        }
    }

    public JCListComponent(int n, boolean bl) {
        this(null, null, null);
        this.visible_rows = n;
        this.multiple_select = bl;
    }

    protected void getParameters() {
        super.getParameters();
        ListConverter.getParams(this);
    }

    public void addItemListener(JCItemListener jCItemListener) {
        this.itemListeners.add(jCItemListener);
    }

    public void removeItemListener(JCItemListener jCItemListener) {
        this.itemListeners.removeElement(jCItemListener);
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.add(jCActionListener);
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        this.actionListeners.removeElement(jCActionListener);
    }

    public synchronized void setFont(Font font) {
        if (this.getFont() != null && this.getFont().equals(font)) {
            return;
        }
        super.setFont(font);
        this.calcSize(true);
    }

    public void setDoubleBuffer(boolean bl) {
    }

    public void invalidate() {
        super.invalidate();
        this.buffer_image = null;
        this.buffer_image_gc = null;
    }

    public Image getDoubleBufferImage() {
        return this.buffer_image;
    }

    public synchronized Graphics getDoubleBufferGraphics() {
        Image image = this.buffer_image;
        this.buffer_image = BWTUtil.createImage(this, this.buffer_image, this.size().width, this.size().height);
        if (this.buffer_image != image || this.buffer_image_gc == null) {
            this.buffer_image_gc = this.buffer_image.getGraphics();
        }
        return this.buffer_image_gc;
    }

    void copyArea(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw_gc = graphics;
        graphics = this.getDoubleBufferGraphics();
        this.buffer_image = this.getDoubleBufferImage();
        this.getDrawingArea(this.draw_rect);
        graphics.setClip(this.draw_rect);
        graphics.copyArea(n, n2, n3, n4, n5, n6);
        graphics.setClip(n + n5, n2 + n6, n3, n4);
        this.draw_gc.drawImage(this.buffer_image, 0, 0, null);
    }

    public Object[] getUserDataList() {
        return this.userdata_list;
    }

    public void setUserDataList(Object[] objectArray) {
        this.userdata_list = objectArray;
        this.updateUserdataList();
    }

    public JCVector getItems() {
        return this.items;
    }

    public Object getItem(int n) {
        return this.items.elementAt(n);
    }

    public void setItems(String[] stringArray) {
        this.setItems(new JCVector(stringArray));
    }

    public synchronized String[] getItemsStrings() {
        String[] stringArray = new String[this.items.size()];
        int n = 0;
        while (n < stringArray.length) {
            Object e = this.items.elementAt(n);
            stringArray[n] = e != null ? e.toString() : "";
            ++n;
        }
        return stringArray;
    }

    public void setItems(JCVector jCVector) {
        this.items = jCVector != null ? jCVector : new JCVector();
        int n = 0;
        while (n < this.selected.length) {
            this.last_selected[n] = false;
            this.selected[n] = false;
            ++n;
        }
        this.focus_row = -1;
        this.calcSize(true);
        this.repaint();
    }

    public boolean getBatched() {
        return this.batched;
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (this.batched) {
            return;
        }
        if (this.needs_recalc) {
            this.calcSize(true);
        }
        if (this.needs_recalc || this.needs_repaint) {
            this.repaint();
        }
        this.needs_repaint = false;
        this.needs_recalc = false;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        this.spacing = n;
        this.calcSize(true);
        this.repaint();
    }

    public int countItems() {
        return this.items.size();
    }

    public synchronized void addItem(Object object, int n) {
        if (n < 0 || n >= this.items.size()) {
            n = this.items.size();
            this.items.addElement(object);
        } else {
            this.items.insertElementAt(object, n);
        }
        this.calcSize(n, true);
        this.repaint();
    }

    public synchronized void addItem(Object object) {
        this.addItem(object, Integer.MAX_VALUE);
    }

    public synchronized void replaceItem(Object object, int n) {
        if (n < this.items.size()) {
            this.items.removeElementAt(n);
            this.addItem(object, n);
        }
    }

    public synchronized void clear() {
        this.setItems((JCVector)null);
    }

    public synchronized void deleteItems(int n, int n2) {
        int n3 = n2 = Math.min(this.items.size() - 1, n2);
        while (n3 >= n) {
            this.items.removeElementAt(n3);
            --n3;
        }
        if (this.selected.length > n) {
            System.arraycopy(this.selected, n2 + 1, this.selected, n, this.selected.length - n2 - 1);
            System.arraycopy(this.last_selected, n2 + 1, this.last_selected, n, this.selected.length - n2 - 1);
        }
        if (this.userdata_list != null && this.userdata_list.length > n) {
            System.arraycopy(this.userdata_list, n2 + 1, this.userdata_list, n, this.userdata_list.length - n2 - 1);
        }
        this.calcSize(true);
        this.repaint();
    }

    public synchronized void deleteItem(int n) {
        this.deleteItems(n, n);
    }

    public synchronized void remove(String string) {
        int n = this.items.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("item " + string + " not found in JCList");
        }
        this.deleteItem(n);
    }

    public synchronized int getSelectedIndex() {
        int n = 0;
        int n2 = this.items.size();
        while (n < this.selected.length && n < n2) {
            if (this.selected[n]) {
                return n;
            }
            ++n;
        }
        return -999;
    }

    public int getTopRow() {
        return this.top_row;
    }

    public void setTopRow(int n) {
        this.top_row = n;
        this.vert_origin = -999;
        this.repaint();
    }

    public void makeVisible(int n) {
        int n2;
        if (n < 0 || n >= this.items.size()) {
            return;
        }
        this.last_visible = n;
        if (n <= this.top_row) {
            n2 = this.getRowPosition(n);
        } else if (n == this.items.size() - 1) {
            n2 = Integer.MAX_VALUE;
        } else if (n >= this.bottom_row) {
            n2 = this.vert_origin + this.getRowPosition(n + 1) - this.getRowPosition(this.bottom_row);
        } else {
            return;
        }
        if (this.scrolled_window != null) {
            this.scrolled_window.scrollVertical(n2);
        }
    }

    public int getVisibleIndex() {
        return this.last_visible;
    }

    public synchronized Object getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n >= 0 && n < this.items.size()) {
            return this.items.elementAt(n);
        }
        return null;
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return null;
        }
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.items.elementAt(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    public synchronized int[] getSelectedIndexes() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2]) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        n2 = 0;
        n = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2]) {
                nArray[n++] = n2;
            }
            ++n2;
        }
        return nArray;
    }

    public synchronized void deselect(int n) {
        if (!this.selected[n]) {
            return;
        }
        if (!this.multiple_select) {
            this.deselectAll();
        } else {
            this.last_selected[n] = false;
            this.selected[n] = false;
            this.paintRow(n);
        }
        JCListInterface jCListInterface = this;
        if (this.scrolled_window != null) {
            jCListInterface = (JCListInterface)((Object)this.scrolled_window);
        }
        JCItemEvent jCItemEvent = new JCItemEvent(jCListInterface, 702, this.items.elementAt(n), 2);
        int n2 = 0;
        while (n2 < this.itemListeners.size()) {
            ((JCItemListener)this.itemListeners.elementAt(n2)).itemStateChanged(jCItemEvent);
            ++n2;
        }
    }

    public synchronized void deselectAll() {
        int n = 0;
        while (n < this.selected.length) {
            if (this.selected[n]) {
                this.last_selected[n] = false;
                this.selected[n] = false;
                this.paintRow(n);
            }
            ++n;
        }
    }

    public synchronized void select(int n) {
        this.select(n, true);
    }

    public synchronized void select(Object object) {
        this.select(object, true);
    }

    public synchronized void select(Object object, boolean bl) {
        int n = this.items.indexOf(object);
        if (n >= 0) {
            ListSelection.select(this, n, bl, null);
        }
    }

    public synchronized void select(int n, boolean bl) {
        ListSelection.select(this, n, bl, null);
    }

    public int find(Object object) {
        int n = this.items.indexOf(object);
        if (n >= 0) {
            return n;
        }
        return -999;
    }

    static boolean inside(Insets insets, int n) {
        return insets != null && Math.min(insets.top, insets.bottom) <= n && n <= Math.max(insets.top, insets.bottom);
    }

    public synchronized boolean isSelected(int n) {
        if (n < this.selected.length && n >= 0 && n < this.items.size()) {
            return this.selected[n];
        }
        return false;
    }

    public boolean allowsMultipleSelections() {
        return this.multiple_select;
    }

    public boolean getAllowMultipleSelections() {
        return this.multiple_select;
    }

    public void setAllowMultipleSelections(boolean bl) {
        this.multiple_select = bl;
    }

    public Rectangle getBounds(int n, boolean bl) {
        if (n < 0 || n >= this.items.size()) {
            return null;
        }
        this.getDrawingArea(this.draw_rect);
        this.draw_rect.reshape(this.draw_rect.x - (bl ? this.horiz_origin : 0), this.draw_rect.y + this.getRowPosition(n) - (bl ? this.vert_origin : 0), Math.max(this.draw_rect.width, this.preferredWidth()), this.getRowHeight(n));
        return this.draw_rect;
    }

    public boolean getAutoSelect() {
        return this.auto_select;
    }

    public void setAutoSelect(boolean bl) {
        this.auto_select = bl;
        this.repaint();
    }

    protected int getRowHeight(int n) {
        if (this.row_height_ext != -998) {
            return this.row_height;
        }
        if (n < this.row_heights.length) {
            return this.row_heights[n];
        }
        return 0;
    }

    protected int calcRowWidth(int n) {
        return BWTUtil.getWidth(this.items.elementAt(n), this);
    }

    protected int getRowPosition(int n) {
        n = Math.max(0, Math.min(n, this.items.size() - 1));
        if (this.row_height_ext != -998) {
            return n * this.row_height;
        }
        if (n < this.row_pos.length) {
            return this.row_pos[n];
        }
        return 0;
    }

    public int getRowHeight() {
        return this.row_height_ext;
    }

    public void setRowHeight(int n) {
        if (n < 0 && n != -997 && n != -998) {
            throw new IllegalArgumentException("invalid row height: " + n);
        }
        this.row_height_ext = n;
        this.calcSize(true);
        this.repaint();
    }

    private boolean inside(int n, int n2, int n3) {
        this.getDrawingArea(this.draw_rect);
        return (n2 += this.horiz_origin) >= this.draw_rect.x && n2 - this.draw_rect.x < this.draw_rect.width && (n3 += this.vert_origin - this.draw_rect.y) >= this.getRowPosition(n) && n3 - this.getRowPosition(n) < this.getRowHeight(n);
    }

    public int eventToRow(Event event, boolean bl) {
        if (this.getPeer() == null || this.items.size() == 0) {
            return -999;
        }
        this.getVisibleRange(this.vis);
        if (this.getBounds(this.vis.top, true).inside(event.x, event.y)) {
            return this.vis.top;
        }
        if (this.getBounds(this.vis.bottom, true).inside(event.x, event.y)) {
            return this.vis.bottom;
        }
        this.getDrawingArea(this.draw_rect);
        if (bl && !this.draw_rect.inside(event.x, event.y + this.space())) {
            return -999;
        }
        int n = event.y + this.vert_origin - this.draw_rect.y;
        if (event.y > this.draw_rect.y + this.draw_rect.height) {
            int n2 = this.vis.bottom;
            while (n2 < this.items.size()) {
                if (n < this.getRowPosition(n2)) {
                    return n2 - 1;
                }
                ++n2;
            }
            return -999;
        }
        if (event.y < this.draw_rect.y) {
            int n3 = this.vis.top;
            while (n3 >= 0) {
                if (n > this.getRowPosition(n3)) {
                    return n3;
                }
                --n3;
            }
            return -999;
        }
        int n4 = this.vis.top + 1;
        while (n4 <= Math.min(this.items.size(), this.vis.bottom + 1)) {
            if (n < this.getRowPosition(n4)) {
                return n4 - 1;
            }
            ++n4;
        }
        if (this.vis.bottom == this.items.size() - 1 && n < this.getRowPosition(this.vis.bottom) + this.getRowHeight(this.vis.bottom)) {
            return this.vis.bottom;
        }
        return -999;
    }

    public int getRows() {
        return this.visible_rows;
    }

    public int getVisibleRows() {
        return this.visible_rows;
    }

    public void setVisibleRows(int n) {
        this.visible_rows = n;
        this.calcSize(true);
    }

    public void getVisibleRange(Insets insets) {
        insets.top = this.top_row;
        insets.bottom = this.bottom_row;
    }

    public Color getSelectedBackground() {
        if (this.selected_bg != null) {
            return this.selected_bg;
        }
        return this.getForeground();
    }

    public void setSelectedBackground(Color color) {
        this.selected_bg = color;
        if (this.getSelectedIndex() >= 0) {
            this.repaint();
        }
    }

    public Color getSelectedForeground() {
        if (this.selected_fg != null) {
            return this.selected_fg;
        }
        return this.getBackground();
    }

    public void setSelectedForeground(Color color) {
        this.selected_fg = color;
        if (this.getSelectedIndex() >= 0) {
            this.repaint();
        }
    }

    public int findItem(char c) {
        c = Character.toUpperCase(c);
        int n = 0;
        while (n < this.items.size()) {
            if (BWTUtil.startsWith(this.items.elementAt(n), c)) {
                return n;
            }
            ++n;
        }
        return -999;
    }

    protected void calcSize(boolean bl) {
        int n;
        if (this.getPeer() == null) {
            return;
        }
        if (this.batched) {
            this.needs_recalc = true;
            return;
        }
        this.updateSelectedList();
        this.updateUserdataList();
        int n2 = 0;
        this.row_height = 0;
        if (this.row_height_ext != -998) {
            this.row_pos = null;
            this.row_heights = null;
            this.row_height = this.row_height_ext == -997 ? this.getToolkit().getFontMetrics(this.getFont()).getHeight() + this.space() : this.row_height_ext;
            n2 = this.items.size() * this.row_height;
        } else {
            if (this.row_heights == null || this.items.size() > this.row_heights.length) {
                this.row_heights = new int[this.items.size()];
                this.row_pos = new int[this.items.size()];
            }
            n = 0;
            while (n < this.items.size()) {
                this.row_heights[n] = BWTUtil.getHeight(this.items.elementAt(n), this) + this.space();
                if (n > 0) {
                    this.row_pos[n] = this.row_pos[n - 1] + this.row_heights[n - 1];
                }
                n2 += this.row_heights[n];
                ++n;
            }
        }
        if (this.visible_rows > 0) {
            if (this.visible_rows < this.items.size()) {
                this.pref_height_internal = this.prevItemPos(this.visible_rows);
            } else {
                int n3 = n = n2 > 0 ? n2 : this.row_height;
                if (n == 0) {
                    n = this.getToolkit().getFontMetrics(this.getFont()).getHeight() + this.space();
                }
                int n4 = n / Math.max(1, this.items.size());
                this.pref_height_internal = n + (this.visible_rows - this.items.size()) * n4;
            }
        } else {
            n = this.row_height;
            if (n == 0) {
                n = this.getToolkit().getFontMetrics(this.getFont()).getHeight() + this.space();
            }
            this.pref_height_internal = n * 4;
            if (this.visible_rows == -998) {
                this.pref_height_internal = Math.max(n2, this.pref_height_internal);
            }
        }
        this.pref_width_internal = 0;
        if (bl) {
            this.updateParent();
        }
    }

    synchronized int[] ensureCapacity(int[] nArray) {
        if (nArray == null || this.items.size() >= nArray.length) {
            if (nArray == null) {
                nArray = new int[this.items.size()];
            } else {
                int n = nArray.length;
                int[] nArray2 = nArray;
                nArray = new int[this.items.size()];
                System.arraycopy(nArray2, 0, nArray, 0, n);
            }
        }
        return nArray;
    }

    protected synchronized void calcSize(int n, boolean bl) {
        if (this.getPeer() == null) {
            return;
        }
        if (this.batched) {
            this.needs_recalc = true;
            return;
        }
        int n2 = this.selected.length;
        this.updateSelectedList();
        if (bl) {
            if (n2 < this.selected.length && n < n2) {
                System.arraycopy(this.selected, n, this.selected, n + 1, n2 - n);
                System.arraycopy(this.last_selected, n, this.last_selected, n + 1, n2 - n);
            }
            this.last_selected[n] = false;
            this.selected[n] = false;
        }
        n2 = this.userdata_list != null ? this.userdata_list.length : 0;
        this.updateUserdataList();
        if (bl && this.userdata_list != null) {
            if (n2 < this.userdata_list.length && n < n2) {
                System.arraycopy(this.userdata_list, n, this.userdata_list, n + 1, n2 - n);
            }
            this.userdata_list[n] = null;
        }
        if (this.row_height_ext != -998) {
            this.calcSize(true);
            return;
        }
        if (bl) {
            n2 = this.row_heights.length;
            this.row_heights = this.ensureCapacity(this.row_heights);
            this.row_pos = this.ensureCapacity(this.row_pos);
            if (n2 < this.row_heights.length && n < n2) {
                System.arraycopy(this.row_heights, n, this.row_heights, n + 1, n2 - n);
            }
        }
        this.row_heights[n] = BWTUtil.getHeight(this.items.elementAt(n), this) + this.space();
        int n3 = 1;
        while (n3 < this.items.size()) {
            this.row_pos[n3] = this.row_pos[n3 - 1] + this.row_heights[n3 - 1];
            ++n3;
        }
        if (this.visible_rows == 0) {
            this.pref_height_internal = 0;
            int n4 = 0;
            while (n4 < this.items.size()) {
                this.pref_height_internal += this.row_heights[n4];
                ++n4;
            }
        }
        this.pref_width_internal = 0;
        this.updateParent();
    }

    protected void updateSelectedList() {
        this.selected = BWTUtil.copyList(this.selected, this.items.size(), false);
        this.last_selected = BWTUtil.copyList(this.last_selected, this.items.size(), false);
    }

    protected void updateUserdataList() {
        if (this.userdata_list != null) {
            this.userdata_list = BWTUtil.copyList(this.userdata_list, this.items.size(), null);
        }
    }

    protected int calcWidestRow() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.items.size()) {
            n = Math.max(n, BWTUtil.getWidth(this.items.elementAt(n2), this));
            ++n2;
        }
        return n + 2 * this.highlight;
    }

    private int prevItemPos(int n) {
        if (n > 0) {
            return this.getRowPosition(n - 1) + this.getRowHeight(n - 1);
        }
        return 0;
    }

    private int space() {
        return 2 * this.highlight + this.spacing;
    }

    public synchronized void repaint() {
        if (this.batched) {
            this.needs_repaint = true;
            return;
        }
        super.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.calcSize(false);
        this.enable11Events(32L);
    }

    protected int preferredWidth() {
        if (this.pref_width_internal == 0) {
            this.pref_width_internal = this.calcWidestRow();
        }
        return this.pref_width_internal;
    }

    protected int preferredHeight() {
        return this.pref_height_internal;
    }

    public void paintRow(int n) {
        if (!this.isShowing() || n < this.top_row || n > this.bottom_row) {
            return;
        }
        if (n < 0 || n >= this.items.size()) {
            return;
        }
        this.paintRow(n, null);
    }

    protected void draw(Graphics graphics, Object object, int n, Rectangle rectangle) {
        BWTUtil.draw(this, graphics, object, n, rectangle);
    }

    protected void drawHighlight(boolean bl) {
        Graphics graphics = this.getGraphics();
        Graphics graphics2 = this.getDoubleBufferGraphics();
        this.drawHighlight(graphics, bl);
        this.drawHighlight(graphics2, bl);
        graphics.dispose();
    }

    protected void drawHighlight(int n, boolean bl) {
        this.drawHighlight(null, n, bl);
    }

    protected void drawHighlight(Graphics graphics, int n, boolean bl) {
        Color color;
        if (!this.isShowing() || n < 0 || n >= this.items.size()) {
            return;
        }
        this.getDrawingArea(this.draw_rect);
        int n2 = this.preferredWidth();
        if (n2 > this.draw_rect.width) {
            n2 += 2 * (this.shadow + this.highlight);
        }
        this.draw_rect.reshape(this.draw_rect.x - this.horiz_origin, this.draw_rect.y + this.getRowPosition(n) - this.vert_origin, Math.max(this.draw_rect.width, n2), this.getRowHeight(n));
        Rectangle rectangle = this.getDrawingArea();
        Color color2 = graphics != null ? graphics.getColor() : null;
        boolean bl2 = false;
        if (graphics == null) {
            bl2 = true;
            graphics = this.getDoubleBufferGraphics();
            graphics.setClip(rectangle);
        }
        Color color3 = color = bl ? this.getHighlightColor() : this.getBackground();
        if (color == null) {
            color = this.getForeground();
        }
        if (!this.isSelected(n)) {
            graphics.setColor(color);
        } else if (bl && this.isSelected(n)) {
            graphics.setColor(Color.yellow);
        }
        if (bl) {
            BWTUtil.drawDashedRect(graphics, this.draw_rect.x, this.draw_rect.y, this.draw_rect.width - 1, this.draw_rect.height - 1);
        } else {
            graphics.drawRect(this.draw_rect.x, this.draw_rect.y, this.draw_rect.width - 1, this.draw_rect.height - 1);
        }
        if (bl2) {
            Graphics graphics2 = this.getGraphics();
            graphics2.drawImage(this.getDoubleBufferImage(), 0, 0, null);
            graphics2.dispose();
            return;
        }
        if (bl2) {
            graphics.dispose();
            return;
        }
        if (color2 != null) {
            graphics.setColor(color2);
        }
    }

    protected synchronized void paintRow(int n, Graphics graphics) {
        this.getDrawingArea(this.clip_rect);
        this.draw_rect.reshape(this.clip_rect.x - this.horiz_origin, this.clip_rect.y + this.getRowPosition(n) - this.vert_origin, this.clip_rect.width + this.horiz_origin, this.getRowHeight(n));
        boolean bl = false;
        if (graphics == null) {
            bl = true;
            graphics = this.getDoubleBufferGraphics();
            graphics.setClip(this.clip_rect);
            if (n < this.selected.length && !this.selected[n]) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.draw_rect.x, this.draw_rect.y, this.draw_rect.width, this.draw_rect.height);
            }
            if (!this.isEnabled()) {
                graphics.setColor(Color.lightGray.darker().darker());
            } else {
                graphics.setColor(this.getForeground());
            }
            graphics.setFont(this.getFont());
        } else if (!this.draw_rect.intersects(this.getPaintRect())) {
            return;
        }
        if (n < this.selected.length && this.selected[n]) {
            graphics.setColor(this.getSelectedBg());
            graphics.fillRect(this.draw_rect.x, this.draw_rect.y, this.draw_rect.width, this.draw_rect.height);
            graphics.setColor(this.getSelectedFg());
        }
        if (this.isEnabled() && n == this.focus_row) {
            this.drawHighlight(graphics, n, true);
        }
        this.draw_rect.translate(this.highlight, this.highlight);
        this.draw_rect.width -= 2 * this.highlight;
        this.draw_rect.height -= 2 * this.highlight;
        this.draw(graphics, this.items.elementAt(n), 3, this.draw_rect);
        if (bl) {
            Graphics graphics2 = this.getGraphics();
            graphics2.drawImage(this.getDoubleBufferImage(), 0, 0, null);
            graphics2.dispose();
            return;
        }
        if (bl) {
            graphics.dispose();
            return;
        }
        if (n < this.selected.length && this.selected[n]) {
            graphics.setColor(this.getForeground());
        }
    }

    Color getSelectedBg() {
        if (this.selected_bg != null) {
            return this.selected_bg;
        }
        return this.getForeground();
    }

    Color getSelectedFg() {
        if (this.selected_fg != null) {
            return this.selected_fg;
        }
        return this.getBackground();
    }

    void setFocus(int n) {
        if (n == this.focus_row) {
            return;
        }
        if (this.focus_row >= 0 && this.focus_row < this.items.size()) {
            this.drawHighlight(this.focus_row, false);
        }
        this.focus_row = n;
        this.drawHighlight(this.focus_row, true);
        if (this.auto_select) {
            ListSelection.selectFocusRow(this, null);
        }
    }

    protected synchronized void paintComponent(Graphics graphics) {
        if (this.items.size() == 0) {
            return;
        }
        this.top_row = Math.max(0, Math.min(this.top_row, this.items.size() - 1));
        if (this.vert_origin == -999) {
            this.vert_origin = this.getRowPosition(this.top_row);
        }
        int n = this.vert_origin + this.getDrawingAreaHeight();
        int n2 = this.top_row + 1;
        while (n2 < this.items.size()) {
            if (this.getRowPosition(n2) >= n) break;
            ++n2;
        }
        this.bottom_row = n2 - 1;
        Color color = null;
        if (!this.isEnabled()) {
            color = graphics.getColor();
            graphics.setColor(Color.lightGray.darker().darker());
        }
        n2 = this.top_row;
        while (n2 <= this.bottom_row) {
            this.paintRow(n2, graphics);
            ++n2;
        }
        if (!this.isEnabled()) {
            graphics.setColor(color);
        }
    }

    protected boolean doubleClickAction(Event event, int n) {
        if (n < 0 || n >= this.selected.length) {
            return false;
        }
        if (!this.selected[n]) {
            this.select(n, false);
        }
        if (this.scrolled_window != null) {
            event.target = this.scrolled_window;
        }
        JCActionEvent jCActionEvent = new JCActionEvent(event.target, event.id, null);
        int n2 = 0;
        while (n2 < this.actionListeners.size()) {
            ((JCActionListener)this.actionListeners.elementAt(n2)).actionPerformed(jCActionEvent);
            ++n2;
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return ListSelection.mouseDrag(this, event);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3;
        super.mouseDown(event, n, n2);
        long l = event.when - JCComponent.popdown_time;
        if (l >= 0L && l < 50L) {
            return true;
        }
        if (event.clickCount > 1) {
            n3 = this.eventToRow(event, true);
            if (n3 == this.last_row) {
                return this.doubleClickAction(event, n3);
            }
            event.clickCount = 1;
        }
        if (this.multiple_select && event.shiftDown()) {
            return ListSelection.beginExtend(this, event);
        }
        if (this.multiple_select && event.controlDown()) {
            return ListSelection.beginToggle(this, event);
        }
        n3 = ListSelection.beginSelect(this, event) ? 1 : 0;
        if (n3 && !this.multiple_select) {
            n3 = ListSelection.endSelect(this, event);
        }
        return n3 != 0;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (event.clickCount > 1) {
            int n3 = this.eventToRow(event, true);
            if (n3 == this.last_row) {
                return true;
            }
            event.clickCount = 1;
        }
        if (this.multiple_select && event.shiftDown()) {
            return ListSelection.endExtend(this, event);
        }
        if (this.multiple_select && event.controlDown()) {
            return ListSelection.endToggle(this, event);
        }
        if (!this.multiple_select) {
            return true;
        }
        return ListSelection.endSelect(this, event);
    }

    public boolean keyDown(Event event, int n) {
        if (event.key == 1005) {
            if (event.controlDown() && event.shiftDown()) {
                return ListSelection.ctrlShiftNextRow(this, event);
            }
            if (event.controlDown()) {
                return ListSelection.ctrlNextRow(this, event);
            }
            if (event.shiftDown()) {
                return ListSelection.shiftNextRow(this, event);
            }
            return ListSelection.normalNextRow(this, event);
        }
        if (event.key == 1004) {
            if (event.controlDown() && event.shiftDown()) {
                return ListSelection.ctrlShiftPrevRow(this, event);
            }
            if (event.controlDown()) {
                return ListSelection.ctrlPrevRow(this, event);
            }
            if (event.shiftDown()) {
                return ListSelection.shiftPrevRow(this, event);
            }
            return ListSelection.normalPrevRow(this, event);
        }
        if (event.key == 10 && this.focus_row >= 0) {
            return this.doubleClickAction(event, this.focus_row);
        }
        if (event.key == 32) {
            return ListSelection.kbdSelect(this, event);
        }
        int n2 = this.findItem((char)n);
        if (n2 != -999) {
            this.deselectAll();
            this.makeVisible(n2);
            ListSelection.select(this, n2, true, event);
            return true;
        }
        return super.keyDown(event, n);
    }

    public int getHorizOrigin() {
        return this.horiz_origin;
    }

    public void setHorizOrigin(int n) {
        this.horiz_origin = n;
    }

    public int getVertOrigin() {
        return this.vert_origin;
    }

    public void setVertOrigin(int n) {
        this.vert_origin = n;
        this.top_row = 0;
        while (this.top_row < this.items.size()) {
            if (this.getRowPosition(this.top_row) + this.getRowHeight(this.top_row) > n) {
                return;
            }
            ++this.top_row;
        }
    }
}

